<?php include 'imb-header1.php'; ?>

    <!-- Main Content -->
    <main>
        <!-- Our Services Section -->
        <section class="pt-100 pb-70">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-title text-center mb-60">
                            <span class="sub-title">Our Services</span>
                            <h2 class="title">Powering Your Business with <span>Seamless Payments</span></h2>
                            <p>Explore our complete range of UPI payment solutions designed for businesses of all sizes, from startups to enterprises.</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".2s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://www.shutterstock.com/image-vector/api-integration-icon-line-style-600nw-2529168901.jpg" alt="API Integration">
                            </div>
                            <h3>UPI API Integration</h3>
                            <p>Seamlessly integrate our UPI payment gateway into your website or mobile app with our developer-friendly REST APIs.</p>
                            <ul class="service-features">
                                <li>Easy-to-implement API endpoints</li>
                                <li>Comprehensive documentation</li>
                                <li>Multiple programming language support</li>
                                <li>Webhook notifications</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".3s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://www.paysprint.in/assets/img/services/upi_api.svg" alt="Merchant Account">
                            </div>
                            <h3>Merchant Account</h3>
                            <p>Get your merchant account activated instantly to start accepting UPI payments with zero setup fees.</p>
                            <ul class="service-features">
                                <li>Instant approval in 2 minutes</li>
                                <li>No hidden charges</li>
                                <li>Real-time transaction monitoring</li>
                                <li>Multi-user access control</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".4s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://cdn.iconscout.com/icon/free/png-256/free-upi-2085056-1747946.png?f=webp" alt="Payment Links">
                            </div>
                            <h3>Payment Links</h3>
                            <p>Create and share payment links via email, SMS or social media to collect payments without a website.</p>
                            <ul class="service-features">
                                <li>Customizable payment pages</li>
                                <li>One-click payment collection</li>
                                <li>Bulk payment requests</li>
                                <li>Recurring billing support</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".2s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRX6HZwTvEE1xeYxq-uifsB16kDUPxc3omGJQ&s" alt="Subscriptions">
                            </div>
                            <h3>Subscription Billing</h3>
                            <p>Automate recurring payments for subscriptions, memberships and installment plans.</p>
                            <ul class="service-features">
                                <li>Flexible billing cycles</li>
                                <li>Customer management</li>
                                <li>Failed payment retries</li>
                                <li>Email notifications</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".3s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://www.fidypay.com/wp-content/uploads/2023/07/UPIQR.svg" alt="Security">
                            </div>
                            <h3>Advanced Security</h3>
                            <p>Enterprise-grade security measures to protect your transactions and customer data.</p>
                            <ul class="service-features">
                                <li>PCI DSS compliant infrastructure</li>
                                <li>Two-factor authentication</li>
                                <li>Fraud detection system</li>
                                <li>Tokenization for sensitive data</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="service-card wow fadeInUp" data-wow-delay=".4s">
                            <div class="service-icon">
                                <img loading="lazy" src="https://iserveu.in/wp-content/uploads/2024/03/Loan-Origination-System.svg" alt="Analytics">
                            </div>
                            <h3>Analytics Dashboard</h3>
                            <p>Powerful analytics tools to track your payment performance and business growth.</p>
                            <ul class="service-features">
                                <li>Real-time transaction reports</li>
                                <li>Custom report generation</li>
                                <li>Export to Excel/PDF</li>
                                <li>Revenue forecasting</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- How It Works Section -->
        <section class="works-section">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-title text-center mb-60">
                            <span class="sub-title">Process</span>
                            <h2 class="title">How imb Pay <span>Works</span></h2>
                            <p>Get started with imb Pay in just a few simple steps and start accepting UPI payments immediately.</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        <div class="work-step">
                            <div class="step-number">1</div>
                            <h4>Create Your Account</h4>
                            <p>Register as a merchant on imb Pay with your basic business details. Get instant approval in just 2 minutes with minimal documentation.</p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="work-step">
                            <div class="step-number">2</div>
                            <h4>Choose Integration Method</h4>
                            <p>Select your preferred integration option - API, SDK, plugins or payment links based on your technical capabilities.</p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="work-step">
                            <div class="step-number">3</div>
                            <h4>Integrate with Your Platform</h4>
                            <p>Follow our simple integration guide to connect imb Pay with your website, app or business system in minutes.</p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="work-step">
                            <div class="step-number">4</div>
                            <h4>Start Accepting Payments</h4>
                            <p>Go live and start accepting UPI payments from your customers with instant settlement to your bank account.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Benefits Section -->
        <section class="pt-100 pb-70">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-title text-center mb-60">
                            <span class="sub-title">Advantages</span>
                            <h2 class="title">Why Businesses Choose <span>imb Pay</span></h2>
                            <p>Discover the unique benefits that make imb Pay the preferred payment gateway for thousands of Indian businesses.</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/zero_fee_icon.png" alt=""> 0% Transaction Fees</h4>
                            <p>Enjoy zero transaction fees on all UPI payments, helping you save significantly compared to other payment methods.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/instant_icon.png" alt=""> Instant Activation</h4>
                            <p>Get your merchant account activated in just 2 minutes with minimal documentation and no setup fees.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/settlement_icon.png" alt=""> Same Day Settlement</h4>
                            <p>Receive payments directly in your bank account on the same day, unlike other gateways that take 1-2 days.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/support_icon.png" alt=""> 24/7 Support</h4>
                            <p>Get dedicated WhatsApp support for all your queries, with average response time under 15 minutes.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/security_benefit_icon.png" alt=""> Bank-Grade Security</h4>
                            <p>Enterprise-level security with PCI DSS compliance, 3D Secure authentication and fraud monitoring.</p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="benefit-card">
                            <h4><img loading="lazy" src="newassets/img/icon/developer_icon.png" alt=""> Developer Friendly</h4>
                            <p>Comprehensive API documentation with code samples in multiple programming languages for easy integration.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="cta-area pt-80 pb-80" style="background: linear-gradient(135deg, #6e8efb 0%, #a777e3 100%);">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-8">
                        <h2 style="color: white; margin-bottom: 20px;">Ready to Transform Your Payment Experience?</h2>
                        <p style="color: rgba(255,255,255,0.9); max-width: 600px;">Join thousands of businesses already using imb Pay for seamless, secure and cost-effective UPI payments.</p>
                    </div>
                    <div class="col-lg-4 text-lg-end">
                        <a href="merchant/register" class="btn" style="background-color: white; color: #6e8efb;">Get Started Now</a>
                    </div>
                </div>
            </div>
        </section>

    </main>
    <!-- Main Content End -->

    <!-- Footer Area -->
    <footer>
        <div class="footer-area">
            <div class="footer-top">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-3 col-sm-6">
                            <div class="footer-widget">
                                <div class="logo">
                                    <a href="index"><img loading="lazy" src="newassets/images/Logo.png" alt="imb Pay Logo"></a>
                                </div>
                                <div class="footer-social">
                                    <ul class="list-wrap">
                                        <li><a href="https://wa.me/919876543210" target="_blank">
                                                <svg class="icon-primary" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="grey" viewBox="0 0 448 512">
                                                    <path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/>
                                                </svg>
                                            </a>
                                        </li>
                                        <li><a href="https://wa.me/919876543210" target="_blank">
                                                <svg class="icon-primary" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="grey" viewBox="0 0 448 512">
                                                    <path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/>
                                                </svg>
                                            </a>
                                        </li>
                                        <li><a href="https://wa.me/919876543210" target="_blank">
                                                <svg class="icon-primary" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="grey" viewBox="0 0 448 512">
                                                    <path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/>
                                                </svg>
                                            </a>
                                        </li>
                                        <li><a href="https://wa.me/919876543210" target="_blank">
                                                <svg class="icon-primary" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="grey" viewBox="0 0 448 512">
                                                    <path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/>
                                                </svg>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="footer-contact">
                                    <span>For Support</span>
                                    <h2 class="title"><a href="https://wa.me/919876543210" target="_blank">+91 9876543210</a></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <div class="footer-widget">
                                <h4 class="fw-title">UPI Gateway</h4>
                                <div class="fw-link">
                                    <ul class="list-wrap">
                                        <li><a href="docs">Documentation</a></li>
                                        <li><a href="https://codes.download.net.in/product-category/plugins/" target="_blank">SDK Files</a></li>
                                        <li><a href="demo">Demo</a></li>
                                        <li><a href="#contact">Contact Us</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <div class="footer-widget">
                                <h4 class="fw-title">Account</h4>
                                <div class="fw-link">
                                    <ul class="list-wrap">
                                        <li><a href="merchant/index">Login</a></li>
                                        <li><a href="merchant/register">Sign UP</a></li>
                                        <li><a href="#">Reset Password</a></li>
                                        <li><a href="#contact">Contact Us</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <div class="footer-widget">
                                <h4 class="fw-title">About Store</h4>
                                <div class="footer-about">
                                    <ul class="list-wrap">
                                        <li><img loading="lazy" src="newassets/img/icon/phone_icon.svg" alt=""><a
                                                href="https://wa.me/919876543210">+91 9876543210</a></li>
                                        <li><img loading="lazy" src="newassets/img/icon/mail_icon.svg" alt=""><a
                                                href="mailto:admin@imb Pay">admin@hostdot.us.cc/pay</a></li>
                                        <li><img loading="lazy" src="newassets/img/icon/loction_icon.svg"
                                                alt=""><span>Delhi, India</span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="cart-img">
                                <img loading="lazy" src="newassets/img/digisah_pay-800h.webp" alt=""
                                    style="height: 24px;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="copyright-text text-end">
                                <p>© 2025 imb Pay Payments API. All Rights Reserved</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Footer Area End -->

    <!-- JS here -->
    <script src="newassets/js/jquery-3.6.0.min.js"></script>
    <script src="newassets/js/bootstrap.min.js"></script>
    <script src="newassets/js/swiper-bundle.min.js"></script>
    <script src="newassets/js/slick.min.js"></script>
    <script src="newassets/js/wow.min.js"></script>
    <script src="newassets/js/main.js"></script>
    
    <script disable-devtool-auto="" src="common/disable-devtool.js" data-url="https://www.google.com/"></script>

</body>

</html>