import okhttp3.*;
import com.google.gson.Gson;
import java.io.IOException;

public class CreateOrder {

    private static final String API_URL = "https://pay.imb.org.in/api/create-order";
    private static final String API_TOKEN = "542a08bc000ceb2570dca59993610565"; // Replace with your API token

    public static void main(String[] args) {
        createOrder();
    }

    private static void createOrder() {
        int orderId = (int) (Math.random() * (999999999 - 123456789 + 1) + 123456789); // Generate a unique order ID

        OrderRequest orderRequest = new OrderRequest(
            "1234567890", // Customer mobile
            API_TOKEN,
            "2", // Amount
            String.valueOf(orderId),
            "https://your_Redirect_URL.in/",
            "Customer-email@gmail.com",
            "Additional data here"
        );

        Gson gson = new Gson();
        String json = gson.toJson(orderRequest);

        RequestBody body = RequestBody.create(json, MediaType.parse("application/json"));
        Request request = new Request.Builder()
                .url(API_URL)
                .post(body)
                .build();

        OkHttpClient client = new OkHttpClient();
        client.newCall(request).enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                System.out.println("Request failed: " + e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    String responseData = response.body().string();
                    OrderResponse orderResponse = gson.fromJson(responseData, OrderResponse.class);
                    System.out.println("Redirect to Payment URL: " + orderResponse.getResult().getPaymentUrl());
                } else {
                    System.out.println("Request failed: " + response.message());
                }
            }
        });
    }
}

class OrderRequest {
    private String customer_mobile;
    private String user_token;
    private String amount;
    private String order_id;
    private String redirect_url;
    private String remark1;
    private String remark2;

    public OrderRequest(String customer_mobile, String user_token, String amount, String order_id, String redirect_url, String remark1, String remark2) {
        this.customer_mobile = customer_mobile;
        this.user_token = user_token;
        this.amount = amount;
        this.order_id = order_id;
        this.redirect_url = redirect_url;
        this.remark1 = remark1;
        this.remark2 = remark2;
    }
}

class OrderResponse {
    private Result result;

    public Result getResult() {
        return result;
    }

    class Result {
        private String payment_url;

        public String getPaymentUrl() {
            return payment_url;
        }
    }
}
