import okhttp3.*
import org.json.JSONObject
import java.io.IOException

fun checkOrderStatus() {
    val url = "https://pay.imb.org.in/api/check-order-status"
    val userToken = "2048f66bef68633fa3262d7a398ab577"  // Replace with your API token
    val orderId = "9876543210"  // Replace with the actual order ID

    val formBody = FormBody.Builder()
        .add("user_token", userToken)
        .add("order_id", orderId)
        .build()

    val request = Request.Builder()
        .url(url)
        .post(formBody)
        .build()

    val client = OkHttpClient()
    client.newCall(request).enqueue(object : Callback {
        override fun onFailure(call: Call, e: IOException) {
            println("Failed to execute request: ${e.message}")
        }

        override fun onResponse(call: Call, response: Response) {
            response.use {
                if (it.isSuccessful) {
                    val responseJson = JSONObject(it.body!!.string())
                    
                    if (responseJson.getString("status") == "COMPLETED") {
                        val result = responseJson.getJSONObject("result")
                        println("Transaction Status: ${result.getString("txnStatus")}")
                        println("Order ID: ${result.getString("orderId")}")
                        println("Amount: ${result.getString("amount")}")
                        println("Date: ${result.getString("date")}")
                        println("UTR: ${result.getString("utr")}")
                    } else {
                        println("Error: ${responseJson.getString("message")}")
                    }
                } else {
                    println("Request failed: ${it.message}")
                }
            }
        }
    })
}

fun main() {
    checkOrderStatus()
}
