import io.ktor.application.*
import io.ktor.http.*
import io.ktor.request.*
import io.ktor.response.*
import io.ktor.routing.*
import io.ktor.server.engine.embeddedServer
import io.ktor.server.netty.Netty

fun main() {
    embeddedServer(Netty, port = 8080) {
        routing {
            post("/webhook") {
                val parameters = call.receiveParameters()
                val status = parameters["status"]
                val orderId = parameters["order_id"]
                val remark1 = parameters["remark1"]
                
                // Process webhook data and log for debugging
                println("Webhook data: Status=$status, OrderID=$orderId, Remark1=$remark1")
                
                when (status) {
                    "SUCCESS" -> {
                        // Update transaction as successful in the database
                        println("Transaction successful for Order ID: $orderId")
                        call.respondText("Transaction successful for Order ID: $orderId", status = HttpStatusCode.OK)
                    }
                    "FAILD" -> {
                        // Update transaction as failed in the database
                        println("Transaction failed for Order ID: $orderId")
                        call.respondText("Transaction failed for Order ID: $orderId", status = HttpStatusCode.OK)
                    }
                    else -> call.respondText("Invalid status received", status = HttpStatusCode.BadRequest)
                }
            }
        }
    }.start(wait = true)
}
