import Foundation

func checkOrderStatus() {
    let url = URL(string: "https://pay.imb.org.in/api/check-order-status")!
    var request = URLRequest(url: url)
    request.httpMethod = "POST"
    
    let userToken = "2048f66bef68633fa3262d7a398ab577" // Replace with your API token
    let orderId = "9876543210" // Replace with the actual order ID
    
    let parameters: [String: Any] = [
        "user_token": userToken,
        "order_id": orderId
    ]
    
    request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
    request.httpBody = parameters.map { "\($0.key)=\($0.value)" }
        .joined(separator: "&")
        .data(using: .utf8)
    
    let task = URLSession.shared.dataTask(with: request) { data, response, error in
        guard let data = data, error == nil else {
            print("Request failed: \(error?.localizedDescription ?? "No data")")
            return
        }
        
        if let jsonResponse = try? JSONSerialization.jsonObject(with: data, options: []) as? [String: Any],
           let status = jsonResponse["status"] as? String,
           let result = jsonResponse["result"] as? [String: Any] {
            if status == "COMPLETED" {
                print("Transaction Status: \(result["txnStatus"] ?? "")")
                print("Order ID: \(result["orderId"] ?? "")")
                print("Amount: \(result["amount"] ?? "")")
                print("Date: \(result["date"] ?? "")")
                print("UTR: \(result["utr"] ?? "")")
            } else {
                print("Error: \(jsonResponse["message"] ?? "")")
            }
        } else {
            print("Failed to parse response.")
        }
    }
    
    task.resume()
}

// Call the function
checkOrderStatus()
