import Vapor

func routes(_ app: Application) throws {
    app.post("webhook") { req -> HTTPStatus in
        let data = try req.content.decode(WebhookData.self)
        
        let status = data.status
        let orderId = data.order_id
        let remark1 = data.remark1

        // Process webhook data
        switch status {
        case "SUCCESS":
            print("Transaction successful for Order ID: \(orderId)")
        case "FAILD":
            print("Transaction failed for Order ID: \(orderId)")
        default:
            print("Invalid status received")
        }
        
        return .ok
    }
}

struct WebhookData: Content {
    let status: String
    let order_id: String
    let remark1: String
}

// Start the Vapor server
public func configure(_ app: Application) throws {
    // Other configurations...
    try routes(app)
}
