#define CROW_MAIN
#include "crow.h"
#include <iostream>

void updateTransactionStatus(const std::string& orderId, const std::string& status, const std::string& remark) {
    std::cout << "Updating transaction " << orderId << " to " << status << " with remark: " << remark << std::endl;
}

int main() {
    crow::SimpleApp app;

    CROW_ROUTE(app, "/webhook").methods("POST"_method)([](const crow::request& req) {
        auto body = crow::json::load(req.body);
        
        if (!body) return crow::response(400, "Invalid JSON data");
        
        std::string status = body["status"].s();
        std::string order_id = body["order_id"].s();
        std::string remark1 = body["remark1"].s();

        if (status == "SUCCESS") {
            updateTransactionStatus(order_id, "SUCCESS", remark1);
            return crow::response("Transaction successful for Order ID: " + order_id);
        } else if (status == "FAILD") {
            updateTransactionStatus(order_id, "FAILED", remark1);
            return crow::response("Transaction failed for Order ID: " + order_id);
        } else {
            return crow::response(400, "Invalid status received");
        }
    });

    app.port(5000).multithreaded().run();
}
