using Microsoft.AspNetCore.Mvc;
using System.IO;
using System.Threading.Tasks;

[ApiController]
[Route("api/[controller]")]
public class WebhookController : ControllerBase
{
    [HttpPost]
    public async Task<IActionResult> HandleWebhook()
    {
        using (var reader = new StreamReader(Request.Body))
        {
            var body = await reader.ReadToEndAsync();
            var form = Microsoft.AspNetCore.WebUtilities.QueryHelpers.ParseQuery(body);

            string status = form.ContainsKey("status") ? form["status"].ToString() : null;
            string orderId = form.ContainsKey("order_id") ? form["order_id"].ToString() : null;
            string remark1 = form.ContainsKey("remark1") ? form["remark1"].ToString() : null;

            // Optional: Log data for debugging
            System.IO.File.AppendAllText("webhook_log.txt", body);

            if (status == "SUCCESS")
            {
                // Process successful transaction
                UpdateTransactionStatus(orderId, "SUCCESS", remark1);
                return Ok($"Transaction successfully updated for Order ID: {orderId}");
            }
            else if (status == "FAILD")
            {
                // Process failed transaction
                UpdateTransactionStatus(orderId, "FAILED", remark1);
                return Ok($"Transaction failed for Order ID: {orderId}");
            }
            else
            {
                return BadRequest("Invalid status received");
            }
        }
    }

    private void UpdateTransactionStatus(string orderId, string status, string remark)
    {
        // Implement database update logic here (e.g., using Entity Framework or SQL)
        // Example:
        // context.Transactions.First(t => t.OrderId == orderId).Status = status;
    }
}
